<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserEmployee extends Model 
{

    protected $table = 'user_employees';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('code', 'first_name', 'last_name', 'title', 'gender', 'phone', 'ktp', 'ktp_image', 'npwp', 'kk', 'kk_image', 'bank_name', 'bank_branch', 'bank_account_number', 'bank_account_name', 'address', 'location_id', 'location_name', 'postcode', 'company_id', 'position_id', 'position_name', 'recomendation_ref', 'status', 'created_by', 'updated_by', 'deleted_by', 'attributes', 'company_name');

    public function Location()
    {
        return $this->belongsTo('App\Models\Location', 'location_id');
    }

    public function Position()
    {
        return $this->belongsTo('App\Models\Position', 'position_id');
    }

    public function company()
    {
        return $this->belongsTo('App\Models\Company', 'company_id');
    }

}